{**
 * templates/editStaticPageForm.tpl
 *
 * Copyright (c) 2014-2020 Simon Fraser University
 * Copyright (c) 2003-2020 John Willinsky
 * Distributed under the GNU GPL v3. For full terms see the file docs/COPYING.
 *
 * Form for editing a static page
 *}
<script src="{$pluginJavaScriptURL}/StaticPageFormHandler.js"></script>
<script>
	$(function() {ldelim}
		// Attach the form handler.
		$('#staticPageForm').pkpHandler(
			'$.pkp.controllers.form.staticPages.StaticPageFormHandler',
			{ldelim}
				previewUrl: {url|json_encode router=PKP\core\PKPApplication::ROUTE_PAGE page="pages" op="preview"}
			{rdelim}
		);
	{rdelim});
</script>

{capture assign=actionUrl}{url router=PKP\core\PKPApplication::ROUTE_COMPONENT component="plugins.generic.staticPages.controllers.grid.StaticPageGridHandler" op="updateStaticPage" existingPageName=$blockName escape=false}{/capture}
<form class="pkp_form" id="staticPageForm" method="post" action="{$actionUrl}">
	{csrf}
	{if $staticPageId}
		<input type="hidden" name="staticPageId" value="{$staticPageId|escape}" />
	{/if}
	{fbvFormArea id="staticPagesFormArea" class="border"}
		{fbvFormSection}
			{fbvElement type="text" label="plugins.generic.staticPages.path" id="path" value=$path maxlength="40" inline=true size=$fbvStyles.size.MEDIUM}
			{fbvElement type="text" label="plugins.generic.staticPages.pageTitle" id="title" value=$title maxlength="255" inline=true multilingual=true size=$fbvStyles.size.MEDIUM}
		{/fbvFormSection}
		{fbvFormSection}
			{capture assign="exampleUrl"}{url|replace:"REPLACEME":"%PATH%" router=PKP\core\PKPApplication::ROUTE_PAGE context=$currentContext->getPath() page="REPLACEME"}{/capture}
			{translate key="plugins.generic.staticPages.viewInstructions" pagesPath=$exampleUrl}
		{/fbvFormSection}
		{fbvFormSection label="plugins.generic.staticPages.content" for="content"}
			{fbvElement type="textarea" multilingual=true name="content" id="content" value=$content rich=true height=$fbvStyles.height.TALL variables=$allowedVariables}
		{/fbvFormSection}
	{/fbvFormArea}
	{fbvFormSection class="formButtons"}
		{fbvElement type="button" class="pkp_helpers_align_left" id="previewButton" label="common.preview"}
		{assign var=buttonId value="submitFormButton"|concat:"-"|uniqid}
		{fbvElement type="submit" class="submitFormButton" id=$buttonId label="common.save"}
	{/fbvFormSection}
</form>
